import { Link, useLocation } from 'react-router-dom'
import { Heart, Facebook, Instagram, Twitter, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

function Layout({ children }) {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="header-content">
          <div className="logo">
            <Heart className="logo-icon" size={32} />
            <span>ВетКлиника</span>
          </div>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              Мои визиты
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              Записаться
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Heart className="footer-logo-icon" size={28} />
              <span>ВетКлиника</span>
            </div>
            <p className="footer-description">
              Профессиональная ветеринарная помощь для ваших питомцев. 
              Мы заботимся о здоровье животных уже более 15 лет.
            </p>
            <div className="social-links">
              <a href="#" className="social-link" aria-label="Facebook">
                <Facebook className="social-icon" size={20} />
              </a>
              <a href="#" className="social-link" aria-label="Instagram">
                <Instagram className="social-icon" size={20} />
              </a>
              <a href="#" className="social-link" aria-label="Twitter">
                <Twitter className="social-icon" size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><Link to="/book">Записаться на прием</Link></li>
              <li><a href="#">Терапия</a></li>
              <li><a href="#">Вакцинация</a></li>
              <li><a href="#">Хирургия</a></li>
              <li><a href="#">Диагностика</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Информация</h3>
            <ul className="footer-links">
              <li><a href="#">О клинике</a></li>
              <li><a href="#">Наши врачи</a></li>
              <li><a href="#">Отзывы</a></li>
              <li><a href="#">Новости</a></li>
              <li><a href="#">Вакансии</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <div className="footer-contact">
              <div className="contact-item">
                <Phone className="contact-icon" size={18} />
                <span>+7 (495) 123-45-67</span>
              </div>
              <div className="contact-item">
                <Mail className="contact-icon" size={18} />
                <span>info@vetclinic.ru</span>
              </div>
              <div className="contact-item">
                <MapPin className="contact-icon" size={18} />
                <span>г. Москва, ул. Ветеринарная, д. 15</span>
              </div>
              <div className="contact-item">
                <Clock className="contact-icon" size={18} />
                <span>Пн-Вс: 9:00 - 21:00</span>
              </div>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 ВетКлиника. Все права защищены.</p>
          <div className="footer-legal">
            <a href="#">Политика конфиденциальности</a>
            <span>|</span>
            <a href="#">Условия использования</a>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

